IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Tarjetas_Cuotas_Opciones]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Tarjetas_Cuotas_Opciones] 
END
GO

CREATE PROCEDURE dbo.CPJ_Tarjetas_Cuotas_Opciones @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pModoDebug				TINYINT
DECLARE @pImporte				DECIMAL(12,2)
DECLARE @pFlag_Web				TINYINT

SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pImporte					= ISNULL(CONVERT(DECIMAL(12,2), dbo.CF_JSON_VALUE(@pJson,'Importe')), 0)
SET @pFlag_Web					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Web')), 0)
/*FIN Variables recibidas por parmetro a traves del JSON*/

/*Tabla de Retorno*/
CREATE TABLE #Tarjetas_Cuotas
(Id_Tarjeta				VARCHAR(10),
Descripcion				VARCHAR(50),
Descrip_Corta			VARCHAR(100),
Cant_Cuotas				TINYINT,
Importe_Cuota			DECIMAL(12,2),
Imp_Total_Orig			DECIMAL(12,2),
Imp_Total_Con_Recargo	DECIMAL(12,2),
Porc_Recargo			DECIMAL(7,5))
/*FIN Tabla de Retorno*/

CREATE TABLE #Valores_Tarjetas_Cred_Filtrada
(Id_Tarjeta				VARCHAR(10),
Descripcion				VARCHAR(50),
Descrip_Corta			VARCHAR(100))

/*Variables Locales*/
DECLARE @SqlQry					NVARCHAR(1000)
DECLARE @Id_Tarjeta				VARCHAR(10)
DECLARE @Descripcion			VARCHAR(50)
DECLARE @Descrip_Corta			VARCHAR(100)
DECLARE @Cant_Cuotas			TINYINT
DECLARE @Importe_Cuota			DECIMAL(12,2)
DECLARE @Imp_Total_Orig			DECIMAL(12,2)
DECLARE @Imp_Total_Con_Recargo	DECIMAL(12,2)
DECLARE @Porc_Recargo			DECIMAL(7,5)
DECLARE @Cant_Total_Cuotas		INT
DECLARE @Coef_Adel				DECIMAL(7,5)
DECLARE @Coef_Venc				DECIMAL(7,5)
/*FIN Variables Locales*/

SET @Imp_Total_Orig = @pImporte

IF @pModoDebug = 1
BEGIN
	PRINT 'Ingreso a Stored Procedure: CPJ_Tarjetas_Cuotas_Opciones'
	PRINT 'Parmetros:'
	PRINT 'pImporte: ' + CONVERT(VARCHAR(20), @pImporte) + '. pFlag_Web: ' + CONVERT(VARCHAR(10), @pFlag_Web)
END

IF @pFlag_Web = 1
BEGIN
	SET @SqlQry =	'INSERT INTO #Valores_Tarjetas_Cred_Filtrada
					(Id_Tarjeta, Descripcion, Descrip_Corta)
					SELECT Id_Tarjeta, ISNULL(Descripcion, ''''), ISNULL(Descrip_Corta, Descripcion) FROM Valores_Tarjetas_Cred
					WHERE
					ISNULL(Activo, 0) = 1
					AND Id_Tarjeta <> ''''
					AND ISNULL(Flag_Deb_Auto, 1) = 1' /*Por defecto lo muestro por eso el ISNULL*/
END
ELSE
BEGIN
	SET @SqlQry =	'INSERT INTO #Valores_Tarjetas_Cred_Filtrada
					(Id_Tarjeta, Descripcion, Descrip_Corta)
					SELECT Id_Tarjeta, ISNULL(Descripcion, ''''), ISNULL(Descrip_Corta, Descripcion) FROM Valores_Tarjetas_Cred
					WHERE
					ISNULL(Activo, 0) = 1
					AND Id_Tarjeta <> '''''
END

EXEC sp_executesql @SqlQry

DECLARE curTarjetas CURSOR FOR
SELECT Id_Tarjeta, Descripcion, Descrip_Corta FROM #Valores_Tarjetas_Cred_Filtrada

OPEN curTarjetas
FETCH NEXT FROM curTarjetas INTO @Id_Tarjeta, @Descripcion, @Descrip_Corta
WHILE @@FETCH_STATUS = 0
BEGIN

	SET @Cant_Total_Cuotas = ISNULL((SELECT ISNULL(COUNT(*), 0) FROM Valores_Tarjetas_Cuotas WHERE Id_Tarjeta = @Id_Tarjeta), 0)
	
	IF(@Cant_Total_Cuotas = 0)
	BEGIN
		SET @Cant_Cuotas			= 1
		SET @Porc_Recargo			= 0
		SET @Importe_Cuota			= @Imp_Total_Orig
		SET @Imp_Total_Con_Recargo	= @Imp_Total_Orig
		
		INSERT INTO #Tarjetas_Cuotas
		(Id_Tarjeta,			Descripcion,			Descrip_Corta,
		Cant_Cuotas,			Importe_Cuota,			Imp_Total_Orig,
		Imp_Total_Con_Recargo,	Porc_Recargo)
		VALUES
		(@Id_Tarjeta,			@Descripcion,		@Descrip_Corta,
		@Cant_Cuotas,			@Importe_Cuota,		@Imp_Total_Orig,
		@Imp_Total_Con_Recargo,	@Porc_Recargo)
	END
	ELSE
	BEGIN
		DECLARE curCuotas CURSOR FOR
		SELECT Cuota, ISNULL(Coef_Adel, 1), ISNULL(Coef_Venc, 1) FROM Valores_Tarjetas_Cuotas
		WHERE
		Id_Tarjeta = @Id_Tarjeta

		OPEN curCuotas
		FETCH NEXT FROM curCuotas INTO @Cant_Cuotas, @Coef_Adel, @Coef_Venc
		WHILE @@FETCH_STATUS = 0
		BEGIN
			/*17/04/2020 Por ahora se multiplica siempre por @Coef_Venc porque en Clarion lo hace a travs de VALORES:Tarjeta_Crit_Cuota = 'V' y aca no lo recibe. Hablado Gabriel y Victor*/
			SET @Importe_Cuota			= ROUND(((@Imp_Total_Orig * @Coef_Venc) /  @Cant_Cuotas) , 0)
			
			IF(@Coef_Venc = 1)
			BEGIN
				SET @Porc_Recargo		= 0
			END
			ELSE
			BEGIN
				SET @Porc_Recargo		= ((@Coef_Venc - 1) * 100)
			END
			
			SET @Imp_Total_Con_Recargo	= @Importe_Cuota * @Cant_Cuotas
			
			INSERT INTO #Tarjetas_Cuotas
			(Id_Tarjeta,			Descripcion,			Descrip_Corta,
			Cant_Cuotas,			Importe_Cuota,			Imp_Total_Orig,
			Imp_Total_Con_Recargo,	Porc_Recargo)
			VALUES
			(@Id_Tarjeta,			@Descripcion,		@Descrip_Corta,
			@Cant_Cuotas,			@Importe_Cuota,		@Imp_Total_Orig,
			@Imp_Total_Con_Recargo,	@Porc_Recargo)

			FETCH NEXT FROM curCuotas INTO @Cant_Cuotas, @Coef_Adel, @Coef_Venc
		END
		CLOSE curCuotas
		DEALLOCATE curCuotas
	END

	FETCH NEXT FROM curTarjetas INTO @Id_Tarjeta, @Descripcion, @Descrip_Corta
END
CLOSE curTarjetas
DEALLOCATE curTarjetas

SELECT * FROM #Tarjetas_Cuotas